/*
 * Decompiled with CFR 0.152.
 */
package moe.ytonidc.dimensional_stomach;

import java.util.HashSet;
import java.util.UUID;
import moe.ytonidc.dimensional_stomach.StomachConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class StomachSlotManager {
    public static final int DEFAULT_LEVEL = 1;
    public static final int MAX_LEVEL = 4;
    public static final int SLOTS_PER_LEVEL = 9;
    public static final int MAX_SLOTS = 36;
    private static final UUID RED_ATTACK_UUID = UUID.fromString("a1b2c3d4-e5f6-1234-5678-9abcdef01234");
    private static final UUID RED_HEALTH_UUID = UUID.fromString("a1b2c3d4-e5f6-1234-5678-9abcdef01235");
    private static final UUID BLUE_SPEED_UUID = UUID.fromString("b2c3d4e5-f6a1-2345-6789-abcdef012345");
    private static final UUID BLUE_RESIST_UUID = UUID.fromString("b2c3d4e5-f6a1-2345-6789-abcdef012346");
    private static final UUID YELLOW_MOVE_UUID = UUID.fromString("c3d4e5f6-a1b2-3456-789a-bcdef0123456");
    private static final UUID YELLOW_ARMOR_UUID = UUID.fromString("c3d4e5f6-a1b2-3456-789a-bcdef0123457");
    private final ItemStackHandler redHandler = this.createHandler(SlotType.RED);
    private final ItemStackHandler blueHandler = this.createHandler(SlotType.BLUE);
    private final ItemStackHandler yellowHandler = this.createHandler(SlotType.YELLOW);
    private int stomachLevel = 1;

    private ItemStackHandler createHandler(final SlotType type) {
        return new ItemStackHandler(36){

            public boolean isItemValid(int slot, ItemStack stack) {
                if (!StomachSlotManager.this.isSlotUnlocked(type, slot)) {
                    return false;
                }
                return stack.m_41614_();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    public int getStomachLevel() {
        return this.stomachLevel;
    }

    public int getUnlockedSlots() {
        return this.stomachLevel * 9;
    }

    public boolean canUpgrade() {
        return this.stomachLevel < 4;
    }

    public boolean upgradeStomach() {
        if (this.canUpgrade()) {
            ++this.stomachLevel;
            return true;
        }
        return false;
    }

    public void resetLevel() {
        this.stomachLevel = 1;
    }

    public void setLevel(int level) {
        this.stomachLevel = Math.max(1, Math.min(4, level));
    }

    public boolean isSlotUnlocked(SlotType type, int slot) {
        return slot < this.getUnlockedSlots();
    }

    public int getUnlockedSlots(SlotType type) {
        return this.getUnlockedSlots();
    }

    public static boolean isSpecialSlot(int slot) {
        return slot >= 0 && slot % 9 == 4;
    }

    public void unlockSlot(SlotType type) {
    }

    public ItemStackHandler getHandler(SlotType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case SlotType.RED -> this.redHandler;
            case SlotType.BLUE -> this.blueHandler;
            case SlotType.YELLOW -> this.yellowHandler;
        };
    }

    public ItemStackHandler getRedHandler() {
        return this.redHandler;
    }

    public ItemStackHandler getBlueHandler() {
        return this.blueHandler;
    }

    public ItemStackHandler getYellowHandler() {
        return this.yellowHandler;
    }

    public double calculateBonus(SlotType type) {
        FoodProperties props;
        Item item;
        ItemStack stack;
        int i;
        ItemStackHandler handler = this.getHandler(type);
        int unlocked = this.getUnlockedSlots(type);
        double bonus = 0.0;
        HashSet<Item> countedItems = new HashSet<Item>();
        double multiplier = (Double)StomachConfig.COMMON.nutritionMultiplier.get();
        double specialMultiplier = (Double)StomachConfig.COMMON.specialSlotMultiplier.get();
        for (i = 0; i < unlocked; ++i) {
            if (!StomachSlotManager.isSpecialSlot(i) || (stack = handler.getStackInSlot(i)).m_41619_() || !stack.m_41614_() || countedItems.contains(item = stack.m_41720_())) continue;
            countedItems.add(item);
            props = stack.getFoodProperties(null);
            if (props == null) continue;
            bonus += (double)props.m_38744_() * multiplier * specialMultiplier;
        }
        for (i = 0; i < unlocked; ++i) {
            if (StomachSlotManager.isSpecialSlot(i) || (stack = handler.getStackInSlot(i)).m_41619_() || !stack.m_41614_() || countedItems.contains(item = stack.m_41720_())) continue;
            countedItems.add(item);
            props = stack.getFoodProperties(null);
            if (props == null) continue;
            bonus += (double)props.m_38744_() * multiplier;
        }
        return bonus;
    }

    public void applyAttributes(Player player) {
        double yellowBonus;
        double blueBonus;
        if (player.m_9236_().f_46443_) {
            return;
        }
        this.removeAttributes(player);
        double redBonus = this.calculateBonus(SlotType.RED);
        if (redBonus > 0.0) {
            AttributeInstance attackAttr = player.m_21051_(Attributes.f_22281_);
            AttributeInstance healthAttr = player.m_21051_(Attributes.f_22276_);
            if (attackAttr != null) {
                attackAttr.m_22125_(new AttributeModifier(RED_ATTACK_UUID, "Stomach Red Attack", redBonus * (Double)StomachConfig.COMMON.redAttackMultiplier.get(), AttributeModifier.Operation.ADDITION));
            }
            if (healthAttr != null) {
                healthAttr.m_22125_(new AttributeModifier(RED_HEALTH_UUID, "Stomach Red Health", redBonus * (Double)StomachConfig.COMMON.redHealthMultiplier.get(), AttributeModifier.Operation.ADDITION));
            }
        }
        if ((blueBonus = this.calculateBonus(SlotType.BLUE)) > 0.0) {
            AttributeInstance speedAttr = player.m_21051_(Attributes.f_22283_);
            AttributeInstance resistAttr = player.m_21051_(Attributes.f_22278_);
            if (speedAttr != null) {
                speedAttr.m_22125_(new AttributeModifier(BLUE_SPEED_UUID, "Stomach Blue Speed", blueBonus * (Double)StomachConfig.COMMON.blueAttackSpeedMultiplier.get(), AttributeModifier.Operation.ADDITION));
            }
            if (resistAttr != null) {
                resistAttr.m_22125_(new AttributeModifier(BLUE_RESIST_UUID, "Stomach Blue Resist", blueBonus * (Double)StomachConfig.COMMON.blueKnockbackResistMultiplier.get(), AttributeModifier.Operation.ADDITION));
            }
        }
        if ((yellowBonus = this.calculateBonus(SlotType.YELLOW)) > 0.0) {
            AttributeInstance moveAttr = player.m_21051_(Attributes.f_22279_);
            AttributeInstance armorAttr = player.m_21051_(Attributes.f_22284_);
            if (moveAttr != null) {
                moveAttr.m_22125_(new AttributeModifier(YELLOW_MOVE_UUID, "Stomach Yellow Move", yellowBonus * (Double)StomachConfig.COMMON.yellowMovementSpeedMultiplier.get(), AttributeModifier.Operation.ADDITION));
            }
            if (armorAttr != null) {
                armorAttr.m_22125_(new AttributeModifier(YELLOW_ARMOR_UUID, "Stomach Yellow Armor", yellowBonus * (Double)StomachConfig.COMMON.yellowArmorMultiplier.get(), AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public void removeAttributes(Player player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        AttributeInstance attackAttr = player.m_21051_(Attributes.f_22281_);
        AttributeInstance healthAttr = player.m_21051_(Attributes.f_22276_);
        AttributeInstance speedAttr = player.m_21051_(Attributes.f_22283_);
        AttributeInstance resistAttr = player.m_21051_(Attributes.f_22278_);
        AttributeInstance moveAttr = player.m_21051_(Attributes.f_22279_);
        AttributeInstance armorAttr = player.m_21051_(Attributes.f_22284_);
        if (attackAttr != null) {
            attackAttr.m_22120_(RED_ATTACK_UUID);
        }
        if (healthAttr != null) {
            healthAttr.m_22120_(RED_HEALTH_UUID);
        }
        if (speedAttr != null) {
            speedAttr.m_22120_(BLUE_SPEED_UUID);
        }
        if (resistAttr != null) {
            resistAttr.m_22120_(BLUE_RESIST_UUID);
        }
        if (moveAttr != null) {
            moveAttr.m_22120_(YELLOW_MOVE_UUID);
        }
        if (armorAttr != null) {
            armorAttr.m_22120_(YELLOW_ARMOR_UUID);
        }
    }

    public CompoundTag saveToNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("stomachLevel", this.stomachLevel);
        tag.m_128365_("redItems", (Tag)this.redHandler.serializeNBT());
        tag.m_128365_("blueItems", (Tag)this.blueHandler.serializeNBT());
        tag.m_128365_("yellowItems", (Tag)this.yellowHandler.serializeNBT());
        return tag;
    }

    public void loadFromNBT(CompoundTag tag) {
        int n = this.stomachLevel = tag.m_128441_("stomachLevel") ? tag.m_128451_("stomachLevel") : 1;
        if (tag.m_128441_("redItems")) {
            this.redHandler.deserializeNBT(tag.m_128469_("redItems"));
        }
        if (tag.m_128441_("blueItems")) {
            this.blueHandler.deserializeNBT(tag.m_128469_("blueItems"));
        }
        if (tag.m_128441_("yellowItems")) {
            this.yellowHandler.deserializeNBT(tag.m_128469_("yellowItems"));
        }
    }

    public static enum SlotType {
        RED,
        BLUE,
        YELLOW;

    }
}

